<?php
/**
 * Template Name: Pricing (Panic-to-Plate)
 * Description: High-converting SaaS-style pricing page with comparison + FAQ.
 */
get_header();
?>

<main class="ptp-main">
  <section class="ptp-hero ptp-hero--pricing">
    <div class="ptp-container">
      <div class="ptp-hero__grid">
        <div>
          <p class="ptp-kicker">Pricing</p>
          <h1 class="ptp-h1">Healthy eating that actually fits real life.</h1>
          <p class="ptp-lead">Choose simple Autopilot planning, or upgrade to full Panic-to-Plate with Rescue Mode—so dinner is covered even on your worst days.</p>

          <div class="ptp-actions ptp-no-print" style="margin-top:18px">
            <a class="ptp-btn" href="#plans">See plans</a>
            <a class="ptp-btn ptp-btn--ghost" href="#faq">Read FAQs</a>
          </div>

          <p class="ptp-small" style="margin-top:14px">Cancel anytime • Secure checkout • Works on mobile</p>
        </div>

        <div class="ptp-hero__card">
          <div class="ptp-hero__stat">
            <span class="ptp-badge">Most popular</span>
            <h3 class="ptp-h3" style="margin-top:10px">Autopilot + Rescue Mode</h3>
            <p class="ptp-small">Autopilot weekly plans + “what can I make right now?” Rescue picks.</p>
          </div>

          <div class="ptp-hero__list">
            <div class="ptp-check">Decision Engine weekly plan</div>
            <div class="ptp-check">Rescue Mode pantry meals</div>
            <div class="ptp-check">Fast videos + grocery lists</div>
            <div class="ptp-check">Plan history + downloads</div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section id="plans" class="ptp-section">
    <div class="ptp-container">
      <div class="ptp-section__head">
        <h2 class="ptp-h2">Pick your plan</h2>
        <p class="ptp-lead ptp-lead--sm">Start small, upgrade any time. Both plans include your Recipe Vault + printable grocery lists.</p>
      </div>

      <div class="ptp-pricing-grid">
        <!-- Basic -->
        <article class="ptp-price-card">
          <div class="ptp-price-head">
            <h3 class="ptp-h3">Basic Autopilot</h3>
            <p class="ptp-muted">Weekly plans with the Decision Engine.</p>
          </div>

          <div class="ptp-price">
            <div class="ptp-price__amount">$9.99<span class="ptp-price__unit">/mo</span></div>
            <div class="ptp-small">Great for: people who want a plan and less thinking.</div>
          </div>

          <ul class="ptp-feature-list">
            <li>Weekly meal plan (B/L/D)</li>
            <li>Grocery list + prep guide</li>
            <li>Cook nights + leftovers toggle</li>
            <li>Recipe Vault access</li>
          </ul>

          <div class="ptp-actions ptp-no-print">
            <a class="ptp-btn ptp-btn--ghost" href="#checkout">Start Basic</a>
          </div>
        </article>

        <!-- Pro -->
        <article class="ptp-price-card ptp-price-card--featured">
          <div class="ptp-price-head">
            <span class="ptp-badge ptp-badge--accent">Best value</span>
            <h3 class="ptp-h3" style="margin-top:10px">Autopilot + Rescue Mode</h3>
            <p class="ptp-muted">Plans + panic button dinners from what you have.</p>
          </div>

          <div class="ptp-price">
            <div class="ptp-price__amount">$14.99<span class="ptp-price__unit">/mo</span></div>
            <div class="ptp-small"><strong>Save 2 months</strong> with annual billing (optional).</div>
          </div>

          <ul class="ptp-feature-list">
            <li>Everything in Basic</li>
            <li><strong>Rescue Mode</strong> (fastest/healthiest/comfort picks)</li>
            <li>Rescue Vault + quick videos</li>
            <li>$10 top-off lists (optional content)</li>
          </ul>

          <div class="ptp-actions ptp-no-print">
            <a class="ptp-btn" href="#checkout">Start Rescue</a>
          </div>
        </article>
      </div>

      <div class="ptp-note-card" style="margin-top:18px">
        <p class="ptp-small"><strong>Note:</strong> Checkout buttons below are placeholders until you connect your MemberPress purchase links. (2 minutes)</p>
      </div>

      <div id="checkout" class="ptp-section" style="padding-top:10px">
        <div class="ptp-container" style="padding:0">
          <div class="ptp-section__head" style="margin-bottom:12px">
            <h2 class="ptp-h2">Checkout</h2>
            <p class="ptp-lead ptp-lead--sm">Connect these buttons to your MemberPress membership checkout pages.</p>
          </div>

          <div class="ptp-checkout-grid">
            <div class="ptp-checkout-card">
              <h3 class="ptp-h3">Basic Autopilot</h3>
              <p class="ptp-small">Link this button to your Basic membership purchase page.</p>
              <div class="ptp-actions ptp-no-print">
                <a class="ptp-btn ptp-btn--ghost" href="<?php echo esc_url( home_url('/join-basic/') ); ?>">Go to Basic Checkout</a>
              </div>
              <p class="ptp-small">Default link: <code>/join-basic/</code></p>
            </div>

            <div class="ptp-checkout-card">
              <h3 class="ptp-h3">Autopilot + Rescue Mode</h3>
              <p class="ptp-small">Link this button to your Rescue membership purchase page.</p>
              <div class="ptp-actions ptp-no-print">
                <a class="ptp-btn" href="<?php echo esc_url( home_url('/join-rescue/') ); ?>">Go to Rescue Checkout</a>
              </div>
              <p class="ptp-small">Default link: <code>/join-rescue/</code></p>
            </div>
          </div>

          <div class="ptp-note-card" style="margin-top:14px">
            <p class="ptp-small">
              Create two WordPress pages named <strong>Join Basic</strong> and <strong>Join Rescue</strong>.
              Then place your MemberPress purchase links/shortcodes on those pages. Once created, these buttons work automatically.
            </p>
          </div>
        </div>
      </div>

    </div>
  </section>

  <section class="ptp-section ptp-section--alt">
    <div class="ptp-container">
      <div class="ptp-section__head">
        <h2 class="ptp-h2">Compare plans</h2>
        <p class="ptp-lead ptp-lead--sm">Everything you need is included—Rescue adds the “save my dinner” layer.</p>
      </div>

      <div class="ptp-table-wrap">
        <table class="ptp-compare">
          <thead>
            <tr>
              <th>Feature</th>
              <th>Basic</th>
              <th>Rescue</th>
            </tr>
          </thead>
          <tbody>
            <tr><td>Decision Engine weekly plan</td><td>✓</td><td>✓</td></tr>
            <tr><td>Cook nights + leftovers toggles</td><td>✓</td><td>✓</td></tr>
            <tr><td>Printable grocery list</td><td>✓</td><td>✓</td></tr>
            <tr><td>Plan history + downloads</td><td>✓</td><td>✓</td></tr>
            <tr><td>Rescue Mode (panic button)</td><td>—</td><td>✓</td></tr>
            <tr><td>Rescue Vault recipes</td><td>—</td><td>✓</td></tr>
            <tr><td>Quick Rescue videos</td><td>—</td><td>✓</td></tr>
          </tbody>
        </table>
      </div>

      <div class="ptp-note-card" style="margin-top:14px">
        <p class="ptp-small"><strong>Tip:</strong> Start Basic and upgrade once you want Rescue Mode. Upgrades are easy in MemberPress.</p>
      </div>
    </div>
  </section>

  <section id="faq" class="ptp-section">
    <div class="ptp-container">
      <div class="ptp-section__head">
        <h2 class="ptp-h2">FAQ</h2>
        <p class="ptp-lead ptp-lead--sm">Quick answers to the stuff people ask before they join.</p>
      </div>

      <div class="ptp-faq-grid">
        <details class="ptp-faq" open>
          <summary>Can I cancel anytime?</summary>
          <p>Yes. Cancel anytime from your account—no awkward emails.</p>
        </details>

        <details class="ptp-faq">
          <summary>Do I have to cook every night?</summary>
          <p>Nope. Autopilot lets you choose 3–7 cook nights. Rescue nights + flex nights are built in.</p>
        </details>

        <details class="ptp-faq">
          <summary>Is this for “perfect eaters”?</summary>
          <p>Absolutely not. Panic-to-Plate is built for real life: busy nights, empty pantries, and “I can’t think” moments.</p>
        </details>

        <details class="ptp-faq">
          <summary>What if I’m picky?</summary>
          <p>Use the “foods you hate” box in Autopilot. The generator avoids those ingredients in titles/ingredients where possible.</p>
        </details>

        <details class="ptp-faq">
          <summary>How does checkout work?</summary>
          <p>Checkout and subscriptions are handled by MemberPress through PayPal (or your chosen gateway). The theme just makes it look great.</p>
        </details>

        <details class="ptp-faq">
          <summary>Do I get grocery lists?</summary>
          <p>Yes. Each Autopilot plan produces a printable grocery list, and members can download it too.</p>
        </details>
      </div>

      <div class="ptp-final-cta">
        <h2 class="ptp-h2">Ready to make dinner easier?</h2>
        <p class="ptp-lead ptp-lead--sm">Start with Autopilot—or go straight to Rescue Mode.</p>
        <div class="ptp-actions ptp-no-print">
          <a class="ptp-btn" href="#checkout">Choose a plan</a>
          <a class="ptp-btn ptp-btn--ghost" href="<?php echo esc_url( home_url('/how-it-works/') ); ?>">How it works</a>
        </div>
      </div>

    </div>
  </section>
</main>

<?php get_footer(); ?>
