<?php if (!defined('ABSPATH')) exit; ?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header class="ptp-topbar">
  <div class="ptp-container">
    <div class="ptp-nav">
      <a class="ptp-brand" href="<?php echo esc_url(home_url('/')); ?>">
        <?php if (function_exists('the_custom_logo') && has_custom_logo()): ?>
          <?php the_custom_logo(); ?>
        <?php else: ?>
          <img class="ptp-logo" src="<?php echo esc_url(get_template_directory_uri().'/assets/brand/logo-horizontal-2400x800.png'); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
        <?php endif; ?>
      </a>

      <nav aria-label="Primary">
        <?php ptp_primary_menu(); ?>
      </nav>

      <div style="display:flex;gap:10px;align-items:center;">
        <?php if (is_user_logged_in()): ?>
          <a class="ptp-cta secondary" href="<?php echo esc_url(home_url('/my-account/')); ?>">My Account</a>
        <?php else: ?>
          <a class="ptp-cta secondary" href="<?php echo esc_url(wp_login_url()); ?>">Log in</a>
        <?php endif; ?>
        <a class="ptp-cta" href="<?php echo esc_url(home_url('/pricing/')); ?>">Get Access</a>
      </div>
    </div>
  </div>
</header>
