<?php get_header(); ?>
<main>
  <section class="ptp-hero">
    <div class="ptp-container">
      <div class="ptp-hero-grid">
        <div>
          <div class="ptp-kicker"><span class="dot" aria-hidden="true"></span> Autopilot plans + Rescue Mode for real life</div>
          <h1>Healthy eating — even when you’re busy, tired, or out of ideas.</h1>
          <p>
            Panic-to-Plate makes the hard part effortless: deciding. Get a weekly plan from Autopilot, and when life happens,
            hit Rescue Mode to cook a real meal from what you already have.
          </p>
          <div class="ptp-hero-actions">
            <a class="ptp-cta" href="<?php echo esc_url(home_url('/pricing/')); ?>">Start membership</a>
            <a class="ptp-cta secondary" href="<?php echo esc_url(home_url('/how-it-works/')); ?>">See how it works</a>
          </div>
          <div class="ptp-stats">
            <div class="ptp-stat"><strong>7‑day plans</strong><span>Simple meals that repeat on purpose</span></div>
            <div class="ptp-stat"><strong>Rescue picks</strong><span>Fastest / healthiest / comfort‑but‑better</span></div>
            <div class="ptp-stat"><strong>Grocery lists</strong><span>Printable + downloadable</span></div>
          </div>
        </div>

        <div class="ptp-card">
          <h3>Quick start</h3>
          <p>Already a member? Jump straight in.</p>
          <div class="mp-actions" style="margin-top:14px;">
            <a class="ptp-cta secondary" href="<?php echo esc_url(home_url('/autopilot/')); ?>">Autopilot</a>
            <a class="ptp-cta secondary" href="<?php echo esc_url(home_url('/rescue-mode/')); ?>">Rescue Mode</a>
            <a class="ptp-cta secondary" href="<?php echo esc_url(home_url('/my-plans/')); ?>">My Plans</a>
          </div>
          <div class="mp-hr"></div>
          <p class="mp-small">
            Tip: Protect those pages with MemberPress rules so only members can access them.
          </p>
        </div>
      </div>
    </div>
  </section>

  <section class="ptp-section">
    <div class="ptp-container">
      <h2>What you get</h2>
      <p class="lead">A plan when you’re motivated. A rescue when you’re not.</p>

      <div class="ptp-feature-grid">
        <div class="ptp-feature">
          <div class="icon">🧭</div>
          <h3>Autopilot Decision Engine</h3>
          <p>Tell us your time, budget, and preferences. Get a weekly plan built from your recipe library.</p>
        </div>
        <div class="ptp-feature">
          <div class="icon">🧯</div>
          <h3>Rescue Mode</h3>
          <p>Select what you have at home and how much time you’ve got. Get 3 instant meal options.</p>
        </div>
        <div class="ptp-feature">
          <div class="icon">🛒</div>
          <h3>Grocery Lists</h3>
          <p>Automatically generated from your planned meals. Print it or download it.</p>
        </div>
      </div>
    </div>
  </section>

  <section class="ptp-section" id="pricing-preview">
    <div class="ptp-container">
      <div class="ptp-section-head">
        <div>
          <h2>Simple membership</h2>
          <p class="lead">Two tiers: Autopilot, or Autopilot + Rescue Mode. Cancel anytime.</p>
        </div>
        <div class="ptp-mini-note">
          <strong>No contracts.</strong> Keep it for a month, or make it a habit.
        </div>
      </div>

      <div class="ptp-pricing-grid">
        <div class="ptp-price">
          <h3>Autopilot</h3>
          <div class="ptp-price-row">
            <span class="ptp-amount">$9.99</span>
            <span class="ptp-period">/ month</span>
          </div>
          <div class="ptp-save">Or <strong>$99/year</strong> (save 2 months)</div>

          <ul class="ptp-list">
            <li>Weekly meal plan generator</li>
            <li>Printable + downloadable grocery lists</li>
            <li>Recipe Vault access</li>
          </ul>

          <div class="mp-actions">
            <a class="ptp-cta secondary" href="<?php echo esc_url(home_url('/pricing/')); ?>">Start Autopilot</a>
          </div>
          <p class="ptp-fine">Best for: people who want a plan and less thinking.</p>
        </div>

        <div class="ptp-price popular">
          <div class="ptp-badge">Most popular</div>
          <h3>Autopilot + Rescue Mode</h3>
          <div class="ptp-price-row">
            <span class="ptp-amount">$14.99</span>
            <span class="ptp-period">/ month</span>
          </div>
          <div class="ptp-save">Or <strong>$149/year</strong> (save 2 months)</div>

          <ul class="ptp-list">
            <li>Everything in Autopilot</li>
            <li>Rescue Mode tool + Rescue Vault</li>
            <li>Quick video walkthroughs (embed)</li>
          </ul>

          <div class="mp-actions">
            <a class="ptp-cta" href="<?php echo esc_url(home_url('/pricing/')); ?>">Unlock Rescue Mode</a>
          </div>
          <p class="ptp-fine">Best for: real life — busy nights, low energy, empty fridge.</p>
        </div>
      </div>

      <div class="ptp-compare">
        <div class="ptp-compare-left">
          <strong>Not sure?</strong> Start Autopilot and upgrade anytime.
        </div>
        <div class="ptp-compare-right">
          <a class="ptp-link" href="<?php echo esc_url(home_url('/pricing/')); ?>">See full plan details →</a>
        </div>
      </div>
    </div>
  </section>
<section class="ptp-section">
    <div class="ptp-container">
      <div class="ptp-card">
        <h2 style="margin:0 0 10px;">Ready to stop thinking about dinner?</h2>
        <p style="margin:0;color:var(--ptp-muted);">Make a plan in 60 seconds — and keep Rescue Mode in your back pocket.</p>
        <div class="mp-actions" style="margin-top:14px;">
          <a class="ptp-cta" href="<?php echo esc_url(home_url('/pricing/')); ?>">Start membership</a>
          <a class="ptp-cta secondary" href="<?php echo esc_url(home_url('/how-it-works/')); ?>">How it works</a>
        </div>
      </div>
    </div>
  </section>

</main>
<?php get_footer(); ?>
